package com.qboxus.tictic.simpleclasses

import android.app.Activity
import android.app.Application
import android.app.Application.ActivityLifecycleCallbacks
import android.content.Context
import android.content.SharedPreferences
import android.os.Build
import android.os.Bundle
import android.text.TextUtils
import android.util.Log
import androidx.annotation.RequiresApi
import cat.ereza.customactivityoncrash.config.CaocConfig
import com.danikula.videocache.HttpProxyCacheServer
import com.facebook.drawee.backends.pipeline.Fresco
import com.qboxus.tictic.Constants
import com.qboxus.tictic.R
import com.google.android.exoplayer2.database.DatabaseProvider
import com.google.android.exoplayer2.database.StandaloneDatabaseProvider
import com.google.android.exoplayer2.upstream.cache.LeastRecentlyUsedCacheEvictor
import com.google.android.exoplayer2.upstream.cache.SimpleCache
import com.google.android.gms.tasks.OnCompleteListener
import com.google.firebase.FirebaseApp
import com.google.firebase.database.ChildEventListener
import com.google.firebase.database.DataSnapshot
import com.google.firebase.database.DatabaseError
import com.google.firebase.database.DatabaseReference
import com.google.firebase.database.FirebaseDatabase
import com.google.firebase.messaging.FirebaseMessaging
import com.smartnsoft.backgrounddetector.BackgroundDetectorCallback
import com.smartnsoft.backgrounddetector.BackgroundDetectorHandler
import com.volley.plus.VPackages.VolleyRequest
import io.agora.rtc2.RtcEngine
import io.paperdb.Paper
import java.io.File

/**
 * Created by qboxus on 3/18/2019.
 */
class TicTicApp : Application(), ActivityLifecycleCallbacks,
    BackgroundDetectorHandler.OnVisibilityChangedListener {
    private var proxy: HttpProxyCacheServer? = null
    private var backgroundDetectorHandler: BackgroundDetectorHandler? = null

    @RequiresApi(api = Build.VERSION_CODES.N)
    override fun onCreate() {
        super.onCreate()
        VolleyRequest.initalizeSdk(this)
        appLevelContext = applicationContext
        sharedPreferences=Functions.getSharedPreference(applicationContext);
        registerActivityLifecycleCallbacks(this)
        backgroundDetectorHandler = BackgroundDetectorHandler(
            BackgroundDetectorCallback(
                BackgroundDetectorHandler.ON_ACTIVITY_RESUMED,
                this
            )
        )
        Fresco.initialize(
            applicationContext,
            ImagePipelineConfigUtils.getDefaultImagePipelineConfig(
                applicationContext
            )
        )

        Paper.init(applicationContext)
        FirebaseApp.initializeApp(applicationContext)
        addFirebaseToken()
        setUserOnline()
        if (leastRecentlyUsedCacheEvictor == null) {
            leastRecentlyUsedCacheEvictor = LeastRecentlyUsedCacheEvictor(exoPlayerCacheSize)
        }
        if (exoDatabaseProvider == null) {
            exoDatabaseProvider = StandaloneDatabaseProvider(applicationContext)
        }
        if (simpleCache == null) {
            simpleCache =
                SimpleCache(cacheDir, leastRecentlyUsedCacheEvictor!!, exoDatabaseProvider!!)
            if (simpleCache!!.cacheSpace >= 400207768) {
                freeMemory()
            }
        }
        initCrashActivity()
        initConfig()
        FileUtils.createNoMediaFile(applicationContext)

    }


    fun initCrashActivity() {
        CaocConfig.Builder.create()
            .backgroundMode(CaocConfig.BACKGROUND_MODE_SILENT)
            .enabled(true)
            .showErrorDetails(true)
            .showRestartButton(true)
            .logErrorOnRestart(true)
            .trackActivities(true)
            .minTimeBetweenCrashesMs(2000)
            .restartActivity(com.qboxus.tictic.activitesfragments.CustomErrorActivity::class.java)
            .errorActivity(com.qboxus.tictic.activitesfragments.CustomErrorActivity::class.java)
            .apply()
    }
    var onlineEventListener: ChildEventListener? = null
    var streamingEventListener: ChildEventListener? = null
    var rootref: DatabaseReference? = null

    lateinit var sharedPreferences: SharedPreferences
    private fun setUserOnline() {
        rootref = FirebaseDatabase.getInstance().reference
        addOnlineListener()
        addStreamingListener()
    }

    fun addStreamingListener() {
        if (streamingEventListener == null) {
            streamingEventListener = object : ChildEventListener {
                override fun onChildAdded(snapshot: DataSnapshot, previousChildName: String?) {
                    try {
                        if (!TextUtils.isEmpty(snapshot.value.toString())) {
                            val model =
                                snapshot.getValue(com.qboxus.tictic.activitesfragments.livestreaming.model.LiveUserModel::class.java)
                            allLiveStreaming[model!!.getStreamingId()] = model
                        }

                    } catch (e: Exception) {
                    }
                }

                override fun onChildChanged(snapshot: DataSnapshot, previousChildName: String?) {}
                override fun onChildRemoved(snapshot: DataSnapshot) {
                    try {
                        if (!TextUtils.isEmpty(snapshot.value.toString())) {
                            val model = snapshot.getValue(
                                com.qboxus.tictic.activitesfragments.livestreaming.model.LiveUserModel::class.java
                            )
                            allLiveStreaming.remove(model!!.getStreamingId())
                        }
                    } catch (e: Exception) {
                    }
                }

                override fun onChildMoved(snapshot: DataSnapshot, previousChildName: String?) {}
                override fun onCancelled(error: DatabaseError) {}
            }
            rootref!!.child(Variables.LiveStreaming).addChildEventListener(streamingEventListener!!)
        }
    }

    fun removeStreamingListener() {
        if (rootref != null && streamingEventListener != null) {
            rootref!!.child(Variables.LiveStreaming).removeEventListener(streamingEventListener!!)
            streamingEventListener = null
        }
    }

    fun addOnlineListener() {
        if (onlineEventListener == null) {
            addOnlineStatus()
            onlineEventListener = object : ChildEventListener {
                override fun onChildAdded(snapshot: DataSnapshot, previousChildName: String?) {
                    if (!TextUtils.isEmpty(snapshot.value.toString())) {
                        val item = snapshot.getValue(
                            com.qboxus.tictic.models.UserOnlineModel::class.java
                        )
                        allOnlineUser[item!!.getUserId()] = item
                    }
                }

                override fun onChildChanged(snapshot: DataSnapshot, previousChildName: String?) {}
                override fun onChildRemoved(snapshot: DataSnapshot) {
                    if (!TextUtils.isEmpty(snapshot.value.toString())) {
                        val item = snapshot.getValue(
                            com.qboxus.tictic.models.UserOnlineModel::class.java
                        )
                        allOnlineUser.remove(item!!.getUserId())
                    }
                }

                override fun onChildMoved(snapshot: DataSnapshot, previousChildName: String?) {}
                override fun onCancelled(error: DatabaseError) {}
            }
            rootref!!.child(Variables.onlineUser).addChildEventListener(onlineEventListener!!)
        }
    }

    fun removeOnlineListener() {
        if (rootref != null && onlineEventListener != null) {
            removeOnlineStatus()
            rootref!!.child(Variables.onlineUser).removeEventListener(onlineEventListener!!)
            onlineEventListener = null
        }
    }

    private fun removeOnlineStatus() {
        if (sharedPreferences.getBoolean(Variables.IS_LOGIN, false)
        ) {
            rootref!!.child(Variables.onlineUser)
                .child(sharedPreferences.getString(Variables.U_ID, "0")!!)
                .removeValue()
        }
    }

    private fun addOnlineStatus() {
        if (sharedPreferences.getBoolean(Variables.IS_LOGIN, false)
        ) {
            val onlineModel = com.qboxus.tictic.models.UserOnlineModel()
            onlineModel.setUserId(
               sharedPreferences.getString(Variables.U_ID, "0")
            )
            onlineModel.setUserName(
                sharedPreferences.getString(Variables.U_NAME, "")
            )
            onlineModel.setUserPic(
                sharedPreferences.getString(Variables.U_PIC, "")
            )
            rootref!!.child(Variables.onlineUser)
                .child(sharedPreferences.getString(Variables.U_ID, "0")!!)
                .onDisconnect().removeValue()

            rootref!!.child(Variables.onlineUser)
                .child(sharedPreferences.getString(Variables.U_ID, "0")!!)
                .keepSynced(true)

            rootref!!.child(Variables.onlineUser)
                .child(sharedPreferences.getString(Variables.U_ID, "0")!!)
                .setValue(onlineModel)
                .addOnCompleteListener {
                    Log.d(
                        Constants.tag,
                        "addOnlineStatus: " + onlineModel.getUserId()
                    )
                }
        }
    }

    fun addFirebaseToken() {
        FirebaseMessaging.getInstance().token
            .addOnCompleteListener(OnCompleteListener { task ->
                if (!task.isSuccessful) {
                    return@OnCompleteListener
                }
                // Get new FCM registration token
                val token = task.result
                Log.d(Constants.tag, "token: $token")
                val editor = sharedPreferences.edit()
                editor.putString(Variables.DEVICE_TOKEN, "" + token)
                editor.commit()
            })
    }

    private fun newProxy(): HttpProxyCacheServer {
        return HttpProxyCacheServer.Builder(applicationContext)
            .maxCacheSize((1024 * 1024 * 1024).toLong())
            .maxCacheFilesCount(50)
            .cacheDirectory(
                File(
                    FileUtils.getAppFolder(
                        applicationContext
                    ) + "videoCache"
                )
            )
            .build()
    }

    // check how much memory is available for cache video
    fun freeMemory() {
        try {
            val dir = cacheDir
            deleteDir(dir)
        } catch (e: Exception) {
            e.printStackTrace()
        }
        System.runFinalization()
        Runtime.getRuntime().gc()
        System.gc()
    }

    // delete the cache if it is full
    fun deleteDir(dir: File?): Boolean {
        return if (dir != null && dir.isDirectory) {
            val children = dir.list()
            for (i in children.indices) {
                val success = deleteDir(File(dir, children[i]))
                if (!success) {
                    return false
                }
            }
            dir.delete()
        } else if (dir != null && dir.isFile) {
            dir.delete()
        } else {
            false
        }
    }

    private var mRtcEngine: RtcEngine? = null
    private val mGlobalConfig =
        com.qboxus.tictic.activitesfragments.livestreaming.rtc.EngineConfig()
    private val mHandler =
        com.qboxus.tictic.activitesfragments.livestreaming.rtc.AgoraEventHandler()
    private val mStatsManager =
        com.qboxus.tictic.activitesfragments.livestreaming.stats.StatsManager()

    private fun initConfig() {
        try {
            mRtcEngine =
                RtcEngine.create(applicationContext, getString(R.string.agora_app_id), mHandler)
            mRtcEngine!!.setChannelProfile(io.agora.rtc2.Constants.CHANNEL_PROFILE_LIVE_BROADCASTING)
            mRtcEngine!!.enableVideo()
            mRtcEngine!!.setLogFile(
                com.qboxus.tictic.activitesfragments.livestreaming.utils.FileUtil.initializeLogFile(
                    applicationContext
                )
            )

        } catch (e: Exception) {
            e.printStackTrace()
        }
        val pref =
            com.qboxus.tictic.activitesfragments.livestreaming.utils.PrefManager.getPreferences(
                applicationContext
            )

        mGlobalConfig.videoDimenIndex = pref.getInt(
            com.qboxus.tictic.activitesfragments.livestreaming.Constants.PREF_RESOLUTION_IDX,
            com.qboxus.tictic.activitesfragments.livestreaming.Constants.DEFAULT_PROFILE_IDX
        )

        val showStats = pref.getBoolean(
            com.qboxus.tictic.activitesfragments.livestreaming.Constants.PREF_ENABLE_STATS,
            false
        )

        mGlobalConfig.setIfShowVideoStats(false)
        mStatsManager.enableStats(false)
        mGlobalConfig.mirrorLocalIndex = pref.getInt(
            com.qboxus.tictic.activitesfragments.livestreaming.Constants.PREF_MIRROR_LOCAL,
            0
        )
        mGlobalConfig.mirrorRemoteIndex = pref.getInt(
            com.qboxus.tictic.activitesfragments.livestreaming.Constants.PREF_MIRROR_REMOTE,
            0
        )
        mGlobalConfig.mirrorEncodeIndex = pref.getInt(
            com.qboxus.tictic.activitesfragments.livestreaming.Constants.PREF_MIRROR_ENCODE,
            0
        )
    }

    fun engineConfig(): com.qboxus.tictic.activitesfragments.livestreaming.rtc.EngineConfig {
        return mGlobalConfig
    }

    fun rtcEngine(): RtcEngine? {
        return mRtcEngine
    }

    fun statsManager(): com.qboxus.tictic.activitesfragments.livestreaming.stats.StatsManager {
        return mStatsManager
    }

    fun registerEventHandler(handler: com.qboxus.tictic.activitesfragments.livestreaming.rtc.EventHandler?) {
        mHandler.addHandler(handler)
    }

    fun removeEventHandler(handler: com.qboxus.tictic.activitesfragments.livestreaming.rtc.EventHandler?) {
        mHandler.removeHandler(handler)
    }

    override fun onActivityCreated(activity: Activity, savedInstanceState: Bundle?) {}
    override fun onTerminate() {
        super.onTerminate()
        unregisterActivityLifecycleCallbacks(this)
    }

    override fun onActivityStarted(activity: Activity) {}
    override fun onActivityResumed(activity: Activity) {
        backgroundDetectorHandler!!.onActivityResumed(activity)
        Functions.RegisterConnectivity(activity) { requestType, response ->
            if (response.equals("disconnected", ignoreCase = true)) {
                removeOnlineListener()
                removeStreamingListener()
                Dialogs.showToastOnTop(
                    activity,
                    null,
                    activity.getString(R.string.your_network_is_unstable)
                )
            } else {
                addOnlineListener()
                addStreamingListener()
            }
        }
    }

    override fun onActivityPaused(activity: Activity) {
        backgroundDetectorHandler!!.onActivityPaused(activity)
        Functions.unRegisterConnectivity(activity)
    }

    override fun onActivityStopped(activity: Activity) {}
    override fun onActivitySaveInstanceState(activity: Activity, outState: Bundle) {}
    override fun onActivityDestroyed(activity: Activity) {}
    override fun onAppGoesToBackground(context: Context?) {
        Log.d(Constants.tag, "onAppGoesToBackground")
        removeOnlineListener()
        removeStreamingListener()
    }

    override fun onAppGoesToForeground(context: Context?) {
        Log.d(Constants.tag, "onAppGoesToForeground")
        addOnlineListener()
        addStreamingListener()
    }

    companion object {
        @JvmField
        var appLevelContext: Context? = null
        var simpleCache: SimpleCache? = null
        var leastRecentlyUsedCacheEvictor: LeastRecentlyUsedCacheEvictor? = null
        var exoDatabaseProvider: DatabaseProvider? = null
        var exoPlayerCacheSize = (100 * 1024 * 1024).toLong()
        var allOnlineUser = HashMap<String, com.qboxus.tictic.models.UserOnlineModel?>()

        @JvmField
        var allLiveStreaming =
            HashMap<String, com.qboxus.tictic.activitesfragments.livestreaming.model.LiveUserModel?>()

        // below code is for cache the videos in local
        @JvmStatic
        fun getProxy(context: Context): HttpProxyCacheServer {
            val app = context.applicationContext as TicTicApp
            return try {
                if (app.proxy == null) app.newProxy().also { app.proxy = it } else app.proxy!!
            } catch (e: Exception) {
                app.newProxy()
            }
        }


        const val TAG = "BanubaVideoEditor"

        // Please set your license token for Banuba Video Editor SDK
        const val ERR_SDK_NOT_INITIALIZED =
            "Banuba Video Editor SDK is not initialized: license token is unknown or incorrect.\nPlease check your license token or contact Banuba"
        const val ERR_LICENSE_REVOKED =
            "License is revoked or expired. Please contact Banuba https://www.banuba.com/faq/kb-tickets/new"

    }
}